DROP TABLE "Fotografie";

CREATE TABLE "Fotografie"
(
  "ID" int4 NOT NULL DEFAULT nextval('public."Fotografie_ID_seq"'::text),
  "OPERATORE" varchar(50),
  "DATA" timestamptz,
  "RULLINO" int4,
  "CONTATORE" int4,
  "NOME_FILE" varchar(255),
  "POSIZIONE" int4,
  "FG_IMAGE_NAME" varchar(255),
  "BG_IMAGE_NAME" varchar(255),
  "ICON_IMAGE_NAME" varchar(255),
  "ASPECT_RATIO" float4,
  "IMAGEX" int4,
  "IMAGEY" int4,
  "CROPLEFT" int4,
  "CROPTOP" int4,
  "CROPRIGHT" int4,
  "CROPBOTTOM" int4,
  "ZOOM" int2,
  "ROTATION" int2,
  "RED" int2,
  "GREEN" int2,
  "BLUE" int2,
  "CONTRAST" int2,
  "BRIGHTNESS" int2,
  "SATURATION" int2,
  "ICONX" int4,
  "ICONY" int4,
  "ICONZOOM" int2,
  "ICONROTATION" int2,
  "TEXT" varchar(255),
  "TEXTX" int4,
  "TEXTY" int4,
  "TEXTZOOM" int2,
  "TEXTROTATION" int4,
  "TEXTALIGN" int2,
  "TEXTCOLOR" int4,
  "FONTSTYLE" int2,
  "FONTNAME" varchar(255),
  "EVENTO" varchar(64),
  "PAGE" varchar(8000)
) 
WITH OIDS;
ALTER TABLE "Fotografie" OWNER TO postgres;

-- Table: "Eventi"

DROP TABLE "Eventi";

CREATE TABLE "Eventi"
(
  "ID" int4 NOT NULL DEFAULT nextval('public."Eventi_ID_seq"'::text),
  "EVENTO" varchar(64)
) 
WITH OIDS;
ALTER TABLE "Eventi" OWNER TO postgres;

-- Table: "Layout"

DROP TABLE "Layout";

CREATE TABLE "Layout"
(
  "ID" int4 NOT NULL DEFAULT nextval('public."Layout_ID_seq"'::text),
  "FG_IMAGE_NAME" varchar(255),
  "BG_IMAGE_NAME" varchar(255),
  "ICON_IMAGE_NAME" varchar(255),
  "ASPECT_RATIO" float4,
  "IMAGEX" int4,
  "IMAGEY" int4,
  "CROPLEFT" int4,
  "CROPTOP" int4,
  "CROPRIGHT" int4,
  "CROPBOTTOM" int4,
  "ZOOM" int2,
  "ROTATION" int2,
  "RED" int2,
  "GREEN" int2,
  "BLUE" int2,
  "CONTRAST" int2,
  "BRIGHTNESS" int2,
  "SATURATION" int2,
  "ICONX" int4,
  "ICONY" int4,
  "ICONZOOM" int2,
  "ICONROTATION" int2,
  "TEXT" varchar(255),
  "TEXTX" int4,
  "TEXTY" int4,
  "TEXTZOOM" int2,
  "TEXTROTATION" int4,
  "TEXTALIGN" int2,
  "TEXTCOLOR" int4,
  "FONTSTYLE" int2,
  "FONTNAME" varchar(255),
  "PAGE" varchar(8000)
) 
WITH OIDS;
ALTER TABLE "Layout" OWNER TO postgres;

-- Table: "Spooler"

DROP TABLE "Spooler";

CREATE TABLE "Spooler"
(
  "ID" int4 NOT NULL DEFAULT nextval('public."Spooler_ID_seq"'::text),
  "STATO" int4,
  "CONTATORE" int4,
  "OPERATORE" varchar(50),
  "RULLINO" int4,
  "DATA" timestamptz,
  "PRIORITA" int4,
  "PRINT_LAYOUT" int4,
  "MIRROR" bool NOT NULL,
  "FORMATO_CARTA" int4,
  "NUMERO_COPIE" int4,
  "NOME_FILE" varchar(255),
  "FG_IMAGE_NAME" varchar(255),
  "BG_IMAGE_NAME" varchar(255),
  "ICON_IMAGE_NAME" varchar(255),
  "ASPECT_RATIO" float4,
  "IMAGEX" int4,
  "IMAGEY" int4,
  "CROPLEFT" int4,
  "CROPTOP" int4,
  "CROPRIGHT" int4,
  "CROPBOTTOM" int4,
  "ZOOM" int2,
  "ROTATION" int2,
  "RED" int2,
  "GREEN" int2,
  "BLUE" int2,
  "CONTRAST" int2,
  "BRIGHTNESS" int2,
  "SATURATION" int2,
  "ICONX" int4,
  "ICONY" int4,
  "ICONZOOM" int2,
  "ICONROTATION" int2,
  "TEXT" varchar(254),
  "TEXTX" int4,
  "TEXTY" int4,
  "TEXTZOOM" int2,
  "TEXTROTATION" int4,
  "TEXTALIGN" int2,
  "TEXTCOLOR" int4,
  "FONTSTYLE" int2,
  "FONTNAME" varchar(255),
  "SPOOLERID" int4,
  "PAGE" varchar(8000)
) 
WITH OIDS;
ALTER TABLE "Spooler" OWNER TO postgres;

-- Table: "Story"

DROP TABLE "Story";

CREATE TABLE "Story"
(
  "ID" int4 NOT NULL DEFAULT nextval('public."Story_ID_seq"'::text),
  "OPERATORE" varchar(50),
  "DATA" timestamptz,
  "IMPORTATE" int4,
  "STAMPATE" int4,
  "FORMATO_CARTA" int4
) 
WITH OIDS;
ALTER TABLE "Story" OWNER TO postgres;

DROP SEQUENCE "Fotografie_ID_seq";

CREATE SEQUENCE "Fotografie_ID_seq"
  INCREMENT 1
  MINVALUE 1;

DROP SEQUENCE "Eventi_ID_seq";

CREATE SEQUENCE "Eventi_ID_seq"
  INCREMENT 1
  MINVALUE 1;

DROP SEQUENCE "Layout_ID_seq";

CREATE SEQUENCE "Layout_ID_seq"
  INCREMENT 1
  MINVALUE 1;

DROP SEQUENCE "Spooler_ID_seq";

CREATE SEQUENCE "Spooler_ID_seq"
  INCREMENT 1
  MINVALUE 1;

DROP SEQUENCE "Story_ID_seq";

CREATE SEQUENCE "Story_ID_seq"
  INCREMENT 1
  MINVALUE 1;
