/**********************************************************************/
/* MSDB6OUT.SQL                                                       */
/*                                                                    */
/* The output of this script (which should be run on the 6.x server)  */
/* is a SQL script to be run against the 7.0 server.                  */
/* The purpose of the generated script is to create a table in 7.0    */
/* msdb that contains a mapping between the 6.x suid (which will have */
/* changed in 7.0) and the login name (which will have remained the   */
/* same).  This information is necessary to accurately convert the    */
/* systasks.ownerloginid to a 7.0 sid.                                */
/*                                                                    */
/* Copyright Microsoft, Inc. 1996, 1997, 1998.                        */
/* All Rights Reserved.                                               */
/*                                                                    */
/* Use, duplication, or disclosure by the United States Government    */
/* is subject to restrictions as set forth in subdivision (c) (1)(ii) */
/* of the Rights in Technical Data and Computer Software clause       */
/* at CFR 252.227-7013.                                               */
/* Microsoft, Inc. One Microsoft Way, Redmond WA. 98052.              */
/**********************************************************************/

PRINT 'RESET'

PRINT 'IF EXISTS (SELECT *'
PRINT '           FROM sysobjects'
PRINT '           WHERE (type = ''U'')'
PRINT '             AND (name = ''suid_6x_lookup''))'
PRINT '  DROP TABLE suid_6x_lookup'
PRINT 'go'
PRINT ''
PRINT 'CREATE TABLE suid_6x_lookup'
PRINT '('
PRINT 'suid SMALLINT    NOT NULL,'
PRINT 'name VARCHAR(30) NOT NULL'
PRINT ')'
PRINT 'go'
PRINT ''
go

SET NOCOUNT ON

DECLARE @name    VARCHAR(30)
DECLARE @suid    VARCHAR(30)
DECLARE @counter INT

DECLARE all_logins CURSOR
FOR SELECT CONVERT(VARCHAR, suid), name 
    FROM master.dbo.syslogins
    WHERE suid IS NOT NULL

OPEN all_logins
FETCH NEXT FROM all_logins INTO @suid, @name
PRINT 'PRINT ''Populating table suid_6x_lookup...'''
PRINT 'PRINT '''''

SELECT @counter = 0
WHILE (@@fetch_status = 0)
BEGIN
  EXECUTE ('PRINT ''INSERT INTO suid_6x_lookup VALUES (' + @suid + ', ''''' + @name + ''''')''')
  FETCH NEXT FROM all_logins INTO @suid, @name
  SELECT @counter = @counter + 1
  IF (@counter % 100) = 0
  BEGIN
    PRINT 'go'
    PRINT ''
  END
END

IF (@counter % 100) <> 0
BEGIN
  PRINT 'go'
  PRINT ''
END

DEALLOCATE all_logins
go

PRINT 'PRINT '''''
PRINT 'PRINT ''Updating suid_6x_lookup from upg_loginmap...'''
PRINT 'PRINT '''''

PRINT 'UPDATE suid_6x_lookup'
PRINT 'SET name = ulm.ntname'
PRINT 'FROM msdb.dbo.suid_6x_lookup sx,'
PRINT '     master.dbo.upg_loginmap ulm'
PRINT 'WHERE (sx.name = ulm.sqlname)'
PRINT 'go'
go